'******************************************************************************
'  DNS routines (UDP required)
'******************************************************************************
'*******************************************************************************
'  Pollin NET-IO Board with Atmega32 / 644 / 644P and ENC28J60
'*******************************************************************************
'
'  Copyright bascom-forum.de (C) [2009]  [DON]
'  -> http://bascom-forum.de/index.php?topic=1781.new;topicseen#new
'  Software based on Code by Ben Zijlstra and Viktor Varga
'  Weiterentwickelt von
'    Huetti,
'    Michael
'    boeserkorn
'    mr_energy
'    HansHans
'    six1, Michael Kcher
'    dabuze                            datetime
'    framuel
'
'   http://creativecommons.org/licenses/by-sa/3.0/de/
'
'   Sie drfen:
'
'     * das Werk bzw. den Inhalt vervielfltigen, verbreiten und ffentlich zugnglich machen
'
'     * Abwandlungen und Bearbeitungen des Werkes bzw. Inhaltes anfertigen
'
'   Zu Den Folgenden Bedingungen:
'
'     * Namensnennung.
'       Sie mssen den Namen des Autors/Rechteinhabers in der von ihm festgelegten Weise nennen.
'
'     * Keine kommerzielle Nutzung.
'       Dieses Werk darf nicht fr kommerzielle Zwecke verwendet werden.
'
'     * Weitergabe unter gleichen Bedingungen.
'       Wenn Sie das lizenzierte Werk bzw. den lizenzierten Inhalt bearbeiten
'       oder in anderer Weise erkennbar als Grundlage fr eigenes Schaffen verwenden,
'       drfen Sie die daraufhin neu entstandenen Werke bzw. Inhalte nur
'       unter Verwendung von Lizenzbedingungen weitergeben, die mit denen
'       dieses Lizenzvertrages identisch oder vergleichbar sind.
'
'   Wobei gilt:
'
'     * Verzichtserklrung
'       Jede der vorgenannten Bedingungen kann aufgehoben werden, sofern Sie
'       die ausdrckliche Einwilligung des Rechteinhabers dazu erhalten.
'
'     * Sonstige Rechte
'       Die Lizenz hat keinerlei Einfluss auf die folgenden Rechte:
'          - Die gesetzlichen Schranken des Urheberrechts und sonstigen
'            Befugnisse zur privaten Nutzung
'          - Das Urheberpersnlichkeitsrecht des Rechteinhabers
'          - Rechte anderer Personen, entweder am Lizenzgegenstand selber oder
'            bezglich seiner Verwendung, zum Beispiel Persnlichkeitsrechte abgebildeter Personen.
'
'  Hinweis
'
'      Im Falle einer Verbreitung mssen Sie anderen alle Lizenzbedingungen
'      mitteilen, die fr dieses Werk gelten. Am einfachsten ist es,
'      einen Link auf http://creativecommons.org/licenses/by-sa/3.0/de/ einzubinden.
'

'*******************************************************************************
$nocompile                                                      'will compile only as an include file

'-------------------------------------------------------------------------------
'  DNS Packet Filter
'-------------------------------------------------------------------------------
Sub Dns_packet_filter
   If Ip_packet_is_for_me() = Nok Then Exit Sub             'Accept only packet for me
   If Ip_b_srcaddr_l <> Dns_b_nameserver_l Then Exit Sub    'discard package, it is not from my nameserver
   Call Dns_reply_received                                  'Process package
End Sub

'-------------------------------------------------------------------------------
'  DNS Every Minute
'-------------------------------------------------------------------------------
'Sub Dns_every_minute
'End Sub

'-------------------------------------------------------------------------------
'  DNS Send Nameserver request
'-------------------------------------------------------------------------------
Sub Dns_send_request
Local Llpos As Byte
Local Llen As Byte
Local Lchar As String * 1
Local Li As Integer
   Call Clear_buffer                                        'Clear the complete buffer
'ETH Header
  #if Include_arp = 1
   If Arp_request_destmac_for_ip(dns_b_nameserver(1)) = Nok Then
      Exit Sub
   End If
  #endif
   Eth_b_src_mac(1) = My_b_macaddr(1)
   Eth_b_src_mac(2) = My_b_macaddr(2)
   Eth_b_src_mac(3) = My_b_macaddr(3)
   Eth_b_src_mac(4) = My_b_macaddr(4)
   Eth_b_src_mac(5) = My_b_macaddr(5)
   Eth_b_src_mac(6) = My_b_macaddr(6)
   Eth_w_packettype = Eth_w_packettype_ip
'IP-header
   Ip_b_vers_and_length = Ip_standard_vers_and_length       'V4, header length=5
   Ip_b_type_of_service = &H00                              'Type of service
   Ip_w_identifier = Ip_get_next_identifier()
   Ip_w_fragmentation = &H0000                              'flags & offset --> not fragmented
   Ip_b_time_to_live = &H80                                 'TTL = 255
   Ip_b_protocol = Ip_protocol_udp                          'protocol UDP
   Ip_b_srcaddr(1) = My_b_ipaddr(1)                         'source address  --> My_b_ipaddr
   Ip_b_srcaddr(2) = My_b_ipaddr(2)                         'source address  --> My_b_ipaddr
   Ip_b_srcaddr(3) = My_b_ipaddr(3)                         'source address  --> My_b_ipaddr
   Ip_b_srcaddr(4) = My_b_ipaddr(4)                         'source address  --> My_b_ipaddr
   Ip_b_destaddr(1) = Dns_b_nameserver(1)
   Ip_b_destaddr(2) = Dns_b_nameserver(2)
   Ip_b_destaddr(3) = Dns_b_nameserver(3)
   Ip_b_destaddr(4) = Dns_b_nameserver(4)
'UDP-header
   Udp_w_src_port = Udp_port_dns
   Udp_w_dest_port = Udp_port_dns
'DNS Frame
   Dns_w_id = Ip_get_next_identifier()                      '<---------------------------------
   Dns_w_flags = Dns_flags_recursive
   Dns_w_qdcount = Reversed_word(1)
   Dns_w_ancount = 0
   Dns_w_nscount = 0
   Dns_w_arcount = 0

   Dns_frameptr = Dns_data_start
   Llpos = Dns_frameptr
   Llen = 0
   For Li = 1 To Len(dns_hostname)
      Lchar = Mid(dns_hostname , Li , 1)
      Incr Dns_frameptr
      If Lchar = "." Then
         Buffer(llpos) = Llen
         Llpos = Dns_frameptr
         Llen = 0
      Else
         Incr Llen
         Buffer(dns_frameptr) = Asc(lchar)
      End If
   Next Li
   Buffer(llpos) = Llen

   Incr Dns_frameptr : Buffer(dns_frameptr) = 0             'end mark
   Incr Dns_frameptr : Buffer(dns_frameptr) = High(dns_type_hostaddress)
   Incr Dns_frameptr : Buffer(dns_frameptr) = Low(dns_type_hostaddress)
   Incr Dns_frameptr : Buffer(dns_frameptr) = High(dns_class_internet)
   Incr Dns_frameptr : Buffer(dns_frameptr) = Low(dns_class_internet)

   Call Ip_set_packet_length(dns_frameptr)
   Call Ip_header_checksum
   Call Udp_set_packet_length(dns_frameptr)
   Call Udp_checksum
   Call Enc28j60packetsend(dns_frameptr)

#if Debug_dns > 0
   Print
   Print "====================================================================="
   Print "  DNS request sent to IP ";
   Call Print_ip(ip_b_destaddr(1) , No_crlf)
   Print " via MAC " ;
   Call Print_mac(eth_b_dest_mac(1) , Crlf)
   Print "---------------------------------------------------------------------"
#endif
#if Debug_dns > 2
   Call Eth_dump_header
   Call Ip_dump_header
   Call Udp_dump_header
   Call Dns_dump_frame
#endif

End Sub

'-------------------------------------------------------------------------------
'  DNS Nameserver reply
'-------------------------------------------------------------------------------
Sub Dns_reply_received
Local Lw As Word
Local Li As Integer
   Lw = Dns_w_flags And Dns_flags_reply
   If Lw <> Dns_flags_reply Then
      Exit Sub
   End If
   Lw = Dns_w_flags And Dns_flags_resultcode
   If Lw <> 0 Then
      Exit Sub
   End If

#if Debug_dns > 0
   Print
   Print "====================================================================="
   Print "  DNS Reply received from IP ";
   Call Print_ip(ip_b_srcaddr(1) , No_crlf)
   Print " via MAC " ;
   Call Print_mac(eth_b_src_mac(1) , Crlf)
   Print "---------------------------------------------------------------------"
#endif
#if Debug_dns > 2
    Call Eth_dump_header
    Call Ip_dump_header
    Call Udp_dump_header
    Call Dns_dump_frame
#endif
   Dns_qdcount = Reversed_word(dns_w_qdcount)
   Dns_ancount = Reversed_word(dns_w_ancount)
   If Dns_ancount < 1 Then Exit Sub
   Dns_frameptr = Dns_data_start
   For Li = 1 To Dns_qdcount                                'jump over the question record(s)
      Call Parse_resource_record(dns_rrtype_question)
   Next Li
   Call Parse_resource_record(dns_rrtype_answer)            ' this is the first answer recource record
End Sub

'-------------------------------------------------------------------------------
'  DNS Parse Resource Record
'-------------------------------------------------------------------------------
Sub Parse_resource_record(byval Rr_type As Byte)
Local Lw As Word
Local Lb As Byte
   Lb = Buffer(dns_frameptr) And &HC0                       'mask bits 0-1
   If Lb = &HC0 Then                                        'if set, then it's an Offset
      Lw = Makeint(buffer(dns_frameptr + 1) , Buffer(dns_frameptr ))
      Lw = Lw And &H3FFF                                    'mask bits 2-15
      Lw = Lw + Dns_frame_start                             'this is the offset from data
      Call Parse_hostname(lw)
      Incr Dns_frameptr : Incr Dns_frameptr
   Else
      Call Parse_hostname(dns_frameptr)
      Dns_frameptr = Dns_frameptr + Len(dns_name)
      Incr Dns_frameptr : Incr Dns_frameptr
   End If
   Dns_type = Makeint(buffer(dns_frameptr + 1) , Buffer(dns_frameptr))
   Incr Dns_frameptr : Incr Dns_frameptr
   Dns_class = Makeint(buffer(dns_frameptr + 1) , Buffer(dns_frameptr))
   Incr Dns_frameptr : Incr Dns_frameptr
   If Rr_type = Dns_rrtype_question Then Exit Sub

   Dns_ttl = Buffer(dns_frameptr)
   Shift Dns_ttl , Left , 8
   Incr Dns_frameptr
   Dns_ttl = Dns_ttl + Buffer(dns_frameptr)
   Shift Dns_ttl , Left , 8
   Incr Dns_frameptr
   Dns_ttl = Dns_ttl + Buffer(dns_frameptr)
   Shift Dns_ttl , Left , 8
   Incr Dns_frameptr
   Dns_ttl = Dns_ttl + Buffer(dns_frameptr)
   Incr Dns_frameptr

'??????????????? hier nochmal reinschauen ???????????????????????
   Dns_rlen = Makeint(buffer(dns_frameptr + 1) , Buffer(dns_frameptr))
   Incr Dns_frameptr : Incr Dns_frameptr
#if Debug_dns > 0
   If Dns_rlen = 4 Then
      Print "Hostname: " ; Dns_name ; " gives ";
      Print "IP-Addr: " ; : Call Print_ip(buffer(dns_frameptr) , No_crlf)
      Print "   (TTL: " ; Dns_ttl ; ")"
   End If
#endif
   Dns_frameptr = Dns_frameptr + Dns_rlen
End Sub

'-------------------------------------------------------------------------------
'  DNS Parse Hostname
'-------------------------------------------------------------------------------
Sub Parse_hostname(byval Frameptr As Word )
Local Lb As Byte
Local Li As Integer
   Dns_name = ""
   Do
      Lb = Buffer(frameptr)
      For Li = 1 To Lb
         Incr Frameptr
         Dns_name = Dns_name + Chr(buffer(frameptr))
      Next Li
      Incr Frameptr
      If Buffer(frameptr) = 0 Then
         Exit Do
      Else
         Dns_name = Dns_name + "."
      End If
   Loop
End Sub

'-------------------------------------------------------------------------------
'  DNS Debugging
'-------------------------------------------------------------------------------
#if Debug_dns > 2
Sub Dns_dump_frame
Local Lw As Word

'Dns_data_start As Byte At Buffer(57) Overlay

    Print "--------------------------------------------------------------------"
    Print "  DNS Data (xx) Bytes"
    Print "--------------------------------------------------------------------"
    Print "          ID: " ; : Call Print_word(dns_w_id , Crlf)
    Print "       Flags: " ; : Call Print_word(dns_w_flags , No_crlf) : Print "   [" ; Bin(dns_w_flags) ; "]"
    Print "     Qdcount: " ; : Call Print_word(dns_w_qdcount , Crlf)
    Print "     Ancount: " ; : Call Print_word(dns_w_ancount , Crlf)
    Print "     Nscount: " ; : Call Print_word(dns_w_nscount , Crlf)
    Print "     Arcount: " ; : Call Print_word(dns_w_arcount , Crlf)
    Lw = Ip_get_packet_length() + 1
    Lw = Lw - Dns_data_start
    Call Dump_buffer(dns__b_data_start , Lw)
End Sub
#endif